setwd("F:\\Wokspace\\C19\\SDL\\Step2\\Pandemiav1.6\\data\\traces")
nameFile <-c("Pandemia (2020-04-18 2145h)")
require(XML)
data <-xmlParse("Pandemia (2020-04-18 2145h).trace.xml")
xTime <-xpathSApply(data, "//Events/EYE_Report/@xTime")
agent <-xpathSApply(data, "//Events/EYE_Report/@agent")
varname <-xpathSApply(data, "//Events/EYE_Report/@varname")
vartype <-xpathSApply(data, "//Events/EYE_Report/@vartype")
varvalue <-xpathSApply(data, "//Events/EYE_Report/@varvalue")
label <-xpathSApply(data, "//Events/EYE_Report/@label")
report_values<-data.frame(xTime, agent, varname, vartype, varvalue, label)
xTime_array <-xpathSApply(data, "//Events/EYE_ReportArray/@xTime")
agent_array <-xpathSApply(data, "//Events/EYE_ReportArray/@agent")
varname_array <-xpathSApply(data, "//Events/EYE_ReportArray/@varname")
vartype_array <-xpathSApply(data, "//Events/EYE_ReportArray/@vartype")
varvalue_array <-xpathSApply(data, "//Events/EYE_ReportArray/@varvalue")
label_array <-xpathSApply(data, "//Events/EYE_ReportArray/@label")
varname_label <-xpathSApply(data, "//Events/EYE_ReportArray/@varname_label")
vartype_label <-xpathSApply(data, "//Events/EYE_ReportArray/@vartype_label")
varvalue_label <-xpathSApply(data, "//Events/EYE_ReportArray/@varvalue_label")
report_array_values<-data.frame(xTime_array, agent_array, varname_label, vartype_label, varvalue_label, varname_array, vartype_array, varvalue_array, label_array)

totalInfective = as.numeric(as.character(report_values$varvalue[report_values$varname=="totalInfective"]))
totalInfectivexTime = as.numeric(as.character(report_values$xTime[report_values$varname=="totalInfective"]))
totalDeceased = as.numeric(as.character(report_values$varvalue[report_values$varname=="totalDeceased"]))
totalDeceasedxTime = as.numeric(as.character(report_values$xTime[report_values$varname=="totalDeceased"]))
susceptible = as.numeric(as.character(report_values$varvalue[report_values$varname=="susceptible"]))
susceptiblexTime = as.numeric(as.character(report_values$xTime[report_values$varname=="susceptible"]))
totalRecovered = as.numeric(as.character(report_values$varvalue[report_values$varname=="totalRecovered"]))
totalRecoveredxTime = as.numeric(as.character(report_values$xTime[report_values$varname=="totalRecovered"]))
totalExposed = as.numeric(as.character(report_values$varvalue[report_values$varname=="totalExposed"]))
totalExposedxTime = as.numeric(as.character(report_values$xTime[report_values$varname=="totalExposed"]))



path<-getwd()
# insightmaker1 -> 1 de delay
# insightmaker -> 0.25 de delay
dataPath <- paste(path,"\\..\\insightmaker.csv",sep="")
insightMaker<- read.csv2(dataPath, header = TRUE, sep = ",", dec=".", stringsAsFactors=FALSE)

########################### Para generar los csv ##########################################
write.csv2(x = data.frame(susceptiblexTime,susceptible), file = "susceptibleSDL.csv")
write.csv2(x = data.frame(totalInfectivexTime, totalInfective), file = "totalInfectiveSDL.csv")
write.csv2(x = data.frame(totalDeceasedxTime, totalDeceased), file = "totalDeceasedSDL.csv")
write.csv2(x = data.frame(totalRecoveredxTime, totalRecovered), file = "totalRecoveredSDL.csv")
write.csv2(x = data.frame(totalExposedxTime, totalExposed), file = "totalExposedSDL.csv")
###########################################################################################



library('plotly')
library('htmlwidgets')




#############################################  susceptible   #############################################

path<-getwd()

grafica1 <- plot_ly(data.frame(susceptiblexTime,susceptible), x = ~susceptiblexTime, y = ~susceptible, type = 'scatter', mode = 'lines', name='Susceptible SDL')
grafica1 <- grafica1 %>% add_trace(x = ~insightMaker$Time,y = ~insightMaker$Susceptible, name = 'Susceptible Insight', line = list(color = 'rgb(22, 96, 167)', width = 4)) 

grafica <- "susceptible.html"

htmlwidgets::saveWidget(as.widget(grafica1), grafica,selfcontained = FALSE)

#############################################################################################################


#############################################  totalInfective   #############################################

path<-getwd()

grafica1 <- plot_ly(data.frame(totalInfectivexTime,totalInfective), x = ~totalInfectivexTime, y = ~totalInfective, type = 'scatter', mode = 'lines', name='Infective SDL')
grafica1 <- grafica1 %>% add_trace(x = ~insightMaker$Time,y = ~insightMaker$Infective, name = 'Infective InisghtMaker', line = list(color = 'rgb(22, 96, 167)', width = 4)) 

grafica <- "totalInfective.html"

htmlwidgets::saveWidget(as.widget(grafica1), grafica,selfcontained = FALSE)


#############################################################################################################

#############################################  totalDeceased   #############################################

path<-getwd()

grafica1 <- plot_ly(data.frame(totalDeceasedxTime,totalDeceased), x = ~totalDeceasedxTime, y = ~totalDeceased, type = 'scatter', mode = 'lines', name='Infective SDL')
grafica1 <- grafica1 %>% add_trace(x = ~insightMaker$Time,y = ~insightMaker$Death, name = 'Infective InisghtMaker', line = list(color = 'rgb(22, 96, 167)', width = 4)) 

grafica <- "totalDeceased.html"

htmlwidgets::saveWidget(as.widget(grafica1), grafica,selfcontained = FALSE)

#############################################################################################################

#############################################  totalRecovered   #############################################

path<-getwd()

grafica1 <- plot_ly(data.frame(totalRecoveredxTime,totalRecovered), x = ~totalRecoveredxTime, y = ~totalRecovered, type = 'scatter', mode = 'lines', name='Infective SDL')
grafica1 <- grafica1 %>% add_trace(x = ~insightMaker$Time,y = ~insightMaker$Recovered, name = 'Infective InisghtMaker', line = list(color = 'rgb(22, 96, 167)', width = 4)) 


grafica <- "totalRecovered.html"

htmlwidgets::saveWidget(as.widget(grafica1), grafica,selfcontained = FALSE)

#############################################################################################################


#############################################  totalExposed   #############################################

path<-getwd()

grafica1 <- plot_ly(data.frame(totalExposedxTime,totalExposed), x = ~totalExposedxTime, y = ~totalExposed, type = 'scatter', mode = 'lines', name='Infective SDL')
grafica1 <- grafica1 %>% add_trace(x = ~insightMaker$Time,y = ~insightMaker$Exposed, name = 'Infective InisghtMaker', line = list(color = 'rgb(22, 96, 167)', width = 4)) 

grafica <- "totalExposed.html"

htmlwidgets::saveWidget(as.widget(grafica1), grafica,selfcontained = FALSE)

#############################################################################################################

totalExposedxTime[totalExposed==max(totalExposed)]

insightMaker$Time[insightMaker$Exposed==max(insightMaker$Exposed)]
